/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import wtf.metio.memoization.core.AbstractMemoizer;

final class BiPredicateMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, Boolean>
implements BiPredicate<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiPredicate<FIRST, SECOND> biPredicate;

    BiPredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiPredicate<FIRST, SECOND> biPredicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biPredicate = Objects.requireNonNull(biPredicate, "Cannot memoize a NULL BiPredicate - provide an actual BiPredicate to fix this.");
    }

    @Override
    public boolean test(FIRST first, SECOND second) {
        return (Boolean)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.biPredicate.test(first, second));
    }
}

