/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class BooleanSupplierMemoizer<KEY>
extends AbstractMemoizer<KEY, Boolean>
implements BooleanSupplier {
    private final Supplier<KEY> keySupplier;
    private final BooleanSupplier supplier;

    BooleanSupplierMemoizer(ConcurrentMap<KEY, Boolean> cache, Supplier<KEY> keySupplier, BooleanSupplier supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL BooleanSupplier - provide an actual BooleanSupplier to fix this.");
    }

    @Override
    public boolean getAsBoolean() {
        return (Boolean)this.computeIfAbsent(this.keySupplier.get(), input -> this.supplier.getAsBoolean());
    }
}

