/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedException;

final class CallableMemoizer<OUTPUT, KEY>
extends AbstractMemoizer<KEY, OUTPUT>
implements Callable<OUTPUT> {
    private final Supplier<KEY> keySupplier;
    private final Callable<OUTPUT> callable;

    CallableMemoizer(ConcurrentMap<KEY, OUTPUT> cache, Supplier<KEY> keySupplier, Callable<OUTPUT> callable) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.callable = Objects.requireNonNull(callable, "Cannot memoize a NULL Callable - provide an actual Callable to fix this.");
    }

    @Override
    public OUTPUT call() throws Exception {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keySupplier.get(), key -> {
                try {
                    return this.callable.call();
                }
                catch (Exception exception) {
                    throw new WrappedException(exception);
                }
            });
        }
        catch (WrappedException exception) {
            throw exception.wrappedException();
        }
    }
}

