/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ConsumerMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, KEY>
implements Consumer<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Consumer<INPUT> consumer;

    ConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, Function<INPUT, KEY> keyFunction, Consumer<INPUT> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'Function.identity()'.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(INPUT input) {
        this.computeIfAbsent(this.keyFunction.apply(input), key -> {
            this.consumer.accept(input);
            return key;
        });
    }
}

