/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleBinaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.DoubleBinaryFunction;

final class DoubleBinaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Double>
implements DoubleBinaryOperator {
    private final DoubleBinaryFunction<KEY> keyFunction;
    private final DoubleBinaryOperator operator;

    DoubleBinaryOperatorMemoizer(ConcurrentMap<KEY, Double> cache, DoubleBinaryFunction<KEY> keyFunction, DoubleBinaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.doubleBinaryOperatorHashCodeKeyFunction()'.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL DoubleBinaryOperator - provide an actual DoubleBinaryOperator to fix this.");
    }

    @Override
    public double applyAsDouble(double left, double right) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(left, right), key -> this.operator.applyAsDouble(left, right));
    }
}

