/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleConsumerMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements DoubleConsumer {
    private final DoubleFunction<KEY> keyFunction;
    private final DoubleConsumer consumer;

    DoubleConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, DoubleFunction<KEY> keyFunction, DoubleConsumer consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(double value) {
        this.computeIfAbsent(this.keyFunction.apply(value), key -> {
            this.consumer.accept(value);
            return key;
        });
    }
}

