/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleFunctionMemoizer<KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements DoubleFunction<OUTPUT> {
    private final DoubleFunction<KEY> keyFunction;
    private final DoubleFunction<OUTPUT> function;

    DoubleFunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, DoubleFunction<KEY> keyFunction, DoubleFunction<OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL DoubleFunction - provide an actual DoubleFunction to fix this.");
    }

    @Override
    public OUTPUT apply(double value) {
        return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.apply(value));
    }
}

