/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoublePredicateMemoizer<KEY>
extends AbstractMemoizer<KEY, Boolean>
implements DoublePredicate {
    private final DoubleFunction<KEY> keyFunction;
    private final DoublePredicate predicate;

    DoublePredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, DoubleFunction<KEY> keyFunction, DoublePredicate predicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.predicate = Objects.requireNonNull(predicate, "Cannot memoize a NULL Predicate - provide an actual Predicate to fix this.");
    }

    @Override
    public boolean test(double value) {
        return (Boolean)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.predicate.test(value));
    }
}

