/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleSupplierMemoizer<KEY>
extends AbstractMemoizer<KEY, Double>
implements DoubleSupplier {
    private final Supplier<KEY> keySupplier;
    private final DoubleSupplier supplier;

    DoubleSupplierMemoizer(ConcurrentMap<KEY, Double> cache, Supplier<KEY> keySupplier, DoubleSupplier supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL Supplier - provide an actual Supplier to fix this.");
    }

    @Override
    public double getAsDouble() {
        return (Double)this.computeIfAbsent(this.keySupplier.get(), input -> this.supplier.getAsDouble());
    }
}

