/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleToIntFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements DoubleToIntFunction {
    private final DoubleFunction<KEY> keyFunction;
    private final DoubleToIntFunction function;

    DoubleToIntFunctionMemoizer(ConcurrentMap<KEY, Integer> cache, DoubleFunction<KEY> keyFunction, DoubleToIntFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL DoubleToIntFunction - provide an actual DoubleToIntFunction to fix this.");
    }

    @Override
    public int applyAsInt(double value) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsInt(value));
    }
}

