/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToLongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleToLongFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Long>
implements DoubleToLongFunction {
    private final DoubleFunction<KEY> keyFunction;
    private final DoubleToLongFunction function;

    DoubleToLongFunctionMemoizer(ConcurrentMap<KEY, Long> cache, DoubleFunction<KEY> keyFunction, DoubleToLongFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL DoubleToLongFunction - provide an actual DoubleToLongFunction to fix this.");
    }

    @Override
    public long applyAsLong(double value) {
        return (Long)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsLong(value));
    }
}

