/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;

final class DoubleUnaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Double>
implements DoubleUnaryOperator {
    private final DoubleFunction<KEY> keyFunction;
    private final DoubleUnaryOperator operator;

    DoubleUnaryOperatorMemoizer(ConcurrentMap<KEY, Double> cache, DoubleFunction<KEY> keyFunction, DoubleUnaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL DoubleUnaryOperator - provide an actual DoubleUnaryOperator to fix this.");
    }

    @Override
    public double applyAsDouble(double operand) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(operand), key -> this.operator.applyAsDouble(operand));
    }
}

