/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import wtf.metio.memoization.core.AbstractMemoizer;

final class FunctionMemoizer<INPUT, KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function<INPUT, OUTPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Function<INPUT, OUTPUT> function;

    FunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, Function<INPUT, KEY> keyFunction, Function<INPUT, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function - provide an actual Function to fix this.");
    }

    @Override
    public OUTPUT apply(INPUT input) {
        return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(input), key -> this.function.apply(input));
    }
}

