/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntBinaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.IntBinaryFunction;

final class IntBinaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements IntBinaryOperator {
    private final IntBinaryFunction<KEY> keyFunction;
    private final IntBinaryOperator operator;

    IntBinaryOperatorMemoizer(ConcurrentMap<KEY, Integer> cache, IntBinaryFunction<KEY> keyFunction, IntBinaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.intBinaryOperatorHashCodeKeyFunction()'.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL IntBinaryOperator - provide an actual IntBinaryOperator to fix this.");
    }

    @Override
    public int applyAsInt(int left, int right) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(left, right), key -> this.operator.applyAsInt(left, right));
    }
}

