/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntConsumerMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements IntConsumer {
    private final IntFunction<KEY> keyFunction;
    private final IntConsumer consumer;

    IntConsumerMemoizer(ConcurrentMap<KEY, Integer> cache, IntFunction<KEY> keyFunction, IntConsumer consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(int value) {
        this.computeIfAbsent(this.keyFunction.apply(value), key -> {
            this.consumer.accept(value);
            return value;
        });
    }
}

