/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntFunctionMemoizer<KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements IntFunction<OUTPUT> {
    private final IntFunction<KEY> keyFunction;
    private final IntFunction<OUTPUT> function;

    IntFunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, IntFunction<KEY> keyFunction, IntFunction<OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL IntFunction - provide an actual IntFunction to fix this.");
    }

    @Override
    public OUTPUT apply(int value) {
        return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.apply(value));
    }
}

