/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntPredicateMemoizer<KEY>
extends AbstractMemoizer<KEY, Boolean>
implements IntPredicate {
    private final IntFunction<KEY> keyFunction;
    private final IntPredicate predicate;

    IntPredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, IntFunction<KEY> keyFunction, IntPredicate predicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.predicate = Objects.requireNonNull(predicate, "Cannot memoize a NULL Predicate - provide an actual Predicate to fix this.");
    }

    @Override
    public boolean test(int value) {
        return (Boolean)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.predicate.test(value));
    }
}

