/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntSupplierMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements IntSupplier {
    private final Supplier<KEY> keySupplier;
    private final IntSupplier supplier;

    IntSupplierMemoizer(ConcurrentMap<KEY, Integer> cache, Supplier<KEY> keySupplier, IntSupplier supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL Supplier - provide an actual Supplier to fix this.");
    }

    @Override
    public int getAsInt() {
        return (Integer)this.computeIfAbsent(this.keySupplier.get(), input -> this.supplier.getAsInt());
    }
}

