/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntToDoubleFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Double>
implements IntToDoubleFunction {
    private final IntFunction<KEY> keyFunction;
    private final IntToDoubleFunction function;

    IntToDoubleFunctionMemoizer(ConcurrentMap<KEY, Double> cache, IntFunction<KEY> keyFunction, IntToDoubleFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL IntToDoubleFunction - provide an actual IntToDoubleFunction to fix this.");
    }

    @Override
    public double applyAsDouble(int value) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsDouble(value));
    }
}

