/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import java.util.function.IntToLongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntToLongFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Long>
implements IntToLongFunction {
    private final IntFunction<KEY> keyFunction;
    private final IntToLongFunction function;

    IntToLongFunctionMemoizer(ConcurrentMap<KEY, Long> cache, IntFunction<KEY> keyFunction, IntToLongFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL IntToLongFunction - provide an actual IntToLongFunction to fix this.");
    }

    @Override
    public long applyAsLong(int value) {
        return (Long)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsLong(value));
    }
}

