/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;

final class IntUnaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements IntUnaryOperator {
    private final IntFunction<KEY> keyFunction;
    private final IntUnaryOperator operator;

    IntUnaryOperatorMemoizer(ConcurrentMap<KEY, Integer> cache, IntFunction<KEY> keyFunction, IntUnaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL IntUnaryOperator - provide an actual IntUnaryOperator to fix this.");
    }

    @Override
    public int applyAsInt(int operand) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(operand), key -> this.operator.applyAsInt(operand));
    }
}

