/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongBinaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.LongBinaryFunction;

final class LongBinaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Long>
implements LongBinaryOperator {
    private final LongBinaryFunction<KEY> keyFunction;
    private final LongBinaryOperator operator;

    LongBinaryOperatorMemoizer(ConcurrentMap<KEY, Long> cache, LongBinaryFunction<KEY> keyFunction, LongBinaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.longBinaryOperatorHashCodeKeyFunction()'.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL LongBinaryOperator - provide an actual LongBinaryOperator to fix this.");
    }

    @Override
    public long applyAsLong(long left, long right) {
        return (Long)this.computeIfAbsent(this.keyFunction.apply(left, right), key -> this.operator.applyAsLong(left, right));
    }
}

