/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongConsumerMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements LongConsumer {
    private final LongFunction<KEY> keyFunction;
    private final LongConsumer consumer;

    LongConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, LongFunction<KEY> keyFunction, LongConsumer consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL LongConsumer - provide an actual LongConsumer to fix this.");
    }

    @Override
    public void accept(long value) {
        this.computeIfAbsent(this.keyFunction.apply(value), key -> {
            this.consumer.accept(value);
            return key;
        });
    }
}

