/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongFunctionMemoizer<KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements LongFunction<OUTPUT> {
    private final LongFunction<KEY> keyFunction;
    private final LongFunction<OUTPUT> function;

    LongFunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, LongFunction<KEY> keyFunction, LongFunction<OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL LongFunction - provide an actual LongFunction to fix this.");
    }

    @Override
    public OUTPUT apply(long value) {
        return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.apply(value));
    }
}

