/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongPredicateMemoizer<KEY>
extends AbstractMemoizer<KEY, Boolean>
implements LongPredicate {
    private final LongFunction<KEY> keyFunction;
    private final LongPredicate predicate;

    LongPredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, LongFunction<KEY> keyFunction, LongPredicate predicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.predicate = Objects.requireNonNull(predicate, "Cannot memoize a NULL Predicate - provide an actual Predicate to fix this.");
    }

    @Override
    public boolean test(long value) {
        return (Boolean)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.predicate.test(value));
    }
}

