/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongSupplierMemoizer<KEY>
extends AbstractMemoizer<KEY, Long>
implements LongSupplier {
    private final Supplier<KEY> keySupplier;
    private final LongSupplier supplier;

    LongSupplierMemoizer(ConcurrentMap<KEY, Long> cache, Supplier<KEY> keySupplier, LongSupplier supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL Supplier - provide an actual Supplier to fix this.");
    }

    @Override
    public long getAsLong() {
        return (Long)this.computeIfAbsent(this.keySupplier.get(), input -> this.supplier.getAsLong());
    }
}

