/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongToDoubleFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Double>
implements LongToDoubleFunction {
    private final LongFunction<KEY> keyFunction;
    private final LongToDoubleFunction function;

    LongToDoubleFunctionMemoizer(ConcurrentMap<KEY, Double> cache, LongFunction<KEY> keyFunction, LongToDoubleFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL LongToDoubleFunction - provide an actual LongToDoubleFunction to fix this.");
    }

    @Override
    public double applyAsDouble(long value) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsDouble(value));
    }
}

