/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongToIntFunctionMemoizer<KEY>
extends AbstractMemoizer<KEY, Integer>
implements LongToIntFunction {
    private final LongFunction<KEY> keyFunction;
    private final LongToIntFunction function;

    LongToIntFunctionMemoizer(ConcurrentMap<KEY, Integer> cache, LongFunction<KEY> keyFunction, LongToIntFunction function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL LongToIntFunction - provide an actual LongToIntFunction to fix this.");
    }

    @Override
    public int applyAsInt(long value) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsInt(value));
    }
}

