/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import wtf.metio.memoization.core.AbstractMemoizer;

final class LongUnaryOperatorMemoizer<KEY>
extends AbstractMemoizer<KEY, Long>
implements LongUnaryOperator {
    private final LongFunction<KEY> keyFunction;
    private final LongUnaryOperator operator;

    LongUnaryOperatorMemoizer(ConcurrentMap<KEY, Long> cache, LongFunction<KEY> keyFunction, LongUnaryOperator operator) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'Long.valueOf()'.");
        this.operator = Objects.requireNonNull(operator, "Cannot memoize a NULL LongUnaryOperator - provide an actual LongUnaryOperator to fix this.");
    }

    @Override
    public long applyAsLong(long operand) {
        return ((Long)this.computeIfAbsent(this.keyFunction.apply(operand), key -> this.operator.applyAsLong(operand))).intValue();
    }
}

