/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ObjDoubleConsumer;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.ObjDoubleFunction;

final class ObjDoubleConsumerMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, KEY>
implements ObjDoubleConsumer<INPUT> {
    private final ObjDoubleFunction<INPUT, KEY> keyFunction;
    private final ObjDoubleConsumer<INPUT> consumer;

    ObjDoubleConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, ObjDoubleFunction<INPUT, KEY> keyFunction, ObjDoubleConsumer<INPUT> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.objDoubleConsumerHashCodeKeyFunction()'.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(INPUT input, double value) {
        this.computeIfAbsent(this.keyFunction.apply(input, value), key -> {
            this.consumer.accept(input, value);
            return key;
        });
    }
}

