/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ObjIntConsumer;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.ObjIntFunction;

final class ObjIntConsumerMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, KEY>
implements ObjIntConsumer<INPUT> {
    private final ObjIntFunction<INPUT, KEY> keyFunction;
    private final ObjIntConsumer<INPUT> consumer;

    ObjIntConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, ObjIntFunction<INPUT, KEY> keyFunction, ObjIntConsumer<INPUT> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.objIntConsumerHashCodeKeyFunction()'.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(INPUT input, int value) {
        this.computeIfAbsent(this.keyFunction.apply(input, value), key -> {
            this.consumer.accept(input, value);
            return key;
        });
    }
}

