/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ObjLongConsumer;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.jdk.ObjLongFunction;

final class ObjLongConsumerMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, KEY>
implements ObjLongConsumer<INPUT> {
    private final ObjLongFunction<INPUT, KEY> keyFunction;
    private final ObjLongConsumer<INPUT> consumer;

    ObjLongConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, ObjLongFunction<INPUT, KEY> keyFunction, ObjLongConsumer<INPUT> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults.objLongConsumerHashCodeKeyFunction()'.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    @Override
    public void accept(INPUT input, long value) {
        this.computeIfAbsent(this.keyFunction.apply(input, value), key -> {
            this.consumer.accept(input, value);
            return key;
        });
    }
}

