/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import wtf.metio.memoization.core.AbstractMemoizer;

final class PredicateMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, Boolean>
implements Predicate<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Predicate<INPUT> predicate;

    PredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, Function<INPUT, KEY> keyFunction, Predicate<INPUT> predicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.predicate = Objects.requireNonNull(predicate, "Cannot memoize a NULL Predicate - provide an actual Predicate to fix this.");
    }

    @Override
    public boolean test(INPUT input) {
        return (Boolean)this.computeIfAbsent(this.keyFunction.apply(input), key -> this.predicate.test(input));
    }
}

