/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class RunnableMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements Runnable {
    private final Supplier<KEY> keySupplier;
    private final Runnable runnable;

    RunnableMemoizer(ConcurrentMap<KEY, KEY> cache, Supplier<KEY> keySupplier, Runnable runnable) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.runnable = Objects.requireNonNull(runnable, "Cannot memoize a NULL Runnable - provide an actual Runnable to fix this.");
    }

    @Override
    public void run() {
        this.computeIfAbsent(this.keySupplier.get(), key -> {
            this.runnable.run();
            return key;
        });
    }
}

