/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import wtf.metio.memoization.core.AbstractMemoizer;

final class SupplierMemoizer<KEY, VALUE>
extends AbstractMemoizer<KEY, VALUE>
implements Supplier<VALUE> {
    private final Supplier<KEY> keySupplier;
    private final Supplier<VALUE> supplier;

    SupplierMemoizer(ConcurrentMap<KEY, VALUE> cache, Supplier<KEY> keySupplier, Supplier<VALUE> supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier, might just be 'MemoizationDefaults.staticKey()'.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL Supplier - provide an actual Supplier to fix this.");
    }

    @Override
    public VALUE get() {
        return (VALUE)this.computeIfAbsent(this.keySupplier.get(), input -> this.supplier.get());
    }
}

