/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToDoubleBiFunctionMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, Double>
implements ToDoubleBiFunction<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final ToDoubleBiFunction<FIRST, SECOND> function;

    ToDoubleBiFunctionMemoizer(ConcurrentMap<KEY, Double> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, ToDoubleBiFunction<FIRST, SECOND> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToDoubleBiFunction - provide an actual ToDoubleBiFunction to fix this.");
    }

    @Override
    public double applyAsDouble(FIRST first, SECOND second) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.function.applyAsDouble(first, second));
    }
}

