/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToDoubleFunctionMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, Double>
implements ToDoubleFunction<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final ToDoubleFunction<INPUT> function;

    ToDoubleFunctionMemoizer(ConcurrentMap<KEY, Double> cache, Function<INPUT, KEY> keyFunction, ToDoubleFunction<INPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToDoubleFunction - provide an actual ToDoubleFunction to fix this.");
    }

    @Override
    public double applyAsDouble(INPUT value) {
        return (Double)this.computeIfAbsent(this.keyFunction.apply(value), key -> this.function.applyAsDouble(value));
    }
}

