/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToIntBiFunctionMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, Integer>
implements ToIntBiFunction<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final ToIntBiFunction<FIRST, SECOND> function;

    ToIntBiFunctionMemoizer(ConcurrentMap<KEY, Integer> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, ToIntBiFunction<FIRST, SECOND> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToIntBiFunction - provide an actual ToIntBiFunction to fix this.");
    }

    @Override
    public int applyAsInt(FIRST first, SECOND second) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.function.applyAsInt(first, second));
    }
}

