/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToIntFunctionMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, Integer>
implements ToIntFunction<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final ToIntFunction<INPUT> function;

    ToIntFunctionMemoizer(ConcurrentMap<KEY, Integer> cache, Function<INPUT, KEY> keyFunction, ToIntFunction<INPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToIntFunction - provide an actual ToIntFunction to fix this.");
    }

    @Override
    public int applyAsInt(INPUT input) {
        return (Integer)this.computeIfAbsent(this.keyFunction.apply(input), key -> this.function.applyAsInt(input));
    }
}

