/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.ToLongBiFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToLongBiFunctionMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, Long>
implements ToLongBiFunction<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final ToLongBiFunction<FIRST, SECOND> function;

    ToLongBiFunctionMemoizer(ConcurrentMap<KEY, Long> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, ToLongBiFunction<FIRST, SECOND> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToLongBiFunction - provide an actual ToLongBiFunction to fix this.");
    }

    @Override
    public long applyAsLong(FIRST first, SECOND second) {
        return (Long)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.function.applyAsLong(first, second));
    }
}

