/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jdk;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;

final class ToLongFunctionMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, Long>
implements ToLongFunction<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final ToLongFunction<INPUT> function;

    ToLongFunctionMemoizer(ConcurrentMap<KEY, Long> cache, Function<INPUT, KEY> keyFunction, ToLongFunction<INPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL ToLongFunction - provide an actual ToLongFunction to fix this.");
    }

    @Override
    public long applyAsLong(INPUT input) {
        return (Long)this.computeIfAbsent(this.keyFunction.apply(input), key -> this.function.applyAsLong(input));
    }
}

