/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jool;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jooq.lambda.function.Consumer2;
import wtf.metio.memoization.core.AbstractMemoizer;

final class Consumer2Memoizer<KEY, TYPE1, TYPE2>
extends AbstractMemoizer<KEY, KEY>
implements Consumer2<TYPE1, TYPE2> {
    private final BiFunction<TYPE1, TYPE2, KEY> keyFunction;
    private final Consumer2<TYPE1, TYPE2> consumer;

    Consumer2Memoizer(ConcurrentMap<KEY, KEY> cache, BiFunction<TYPE1, TYPE2, KEY> keyFunction, Consumer2<TYPE1, TYPE2> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer2 - provide an actual Consumer2 to fix this.");
    }

    public void accept(TYPE1 v1, TYPE2 v2) {
        this.computeIfAbsent(this.keyFunction.apply(v1, v2), key -> {
            this.consumer.accept(v1, v2);
            return key;
        });
    }
}

