/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jool;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jooq.lambda.function.Consumer3;
import org.jooq.lambda.function.Function3;
import wtf.metio.memoization.core.AbstractMemoizer;

final class Consumer3Memoizer<KEY, TYPE1, TYPE2, TYPE3>
extends AbstractMemoizer<KEY, KEY>
implements Consumer3<TYPE1, TYPE2, TYPE3> {
    private final Function3<TYPE1, TYPE2, TYPE3, KEY> keyFunction;
    private final Consumer3<TYPE1, TYPE2, TYPE3> consumer;

    Consumer3Memoizer(ConcurrentMap<KEY, KEY> cache, Function3<TYPE1, TYPE2, TYPE3, KEY> keyFunction, Consumer3<TYPE1, TYPE2, TYPE3> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer3 - provide an actual Consumer3 to fix this.");
    }

    public void accept(TYPE1 v1, TYPE2 v2, TYPE3 v3) {
        this.computeIfAbsent(this.keyFunction.apply(v1, v2, v3), key -> {
            this.consumer.accept(v1, v2, v3);
            return key;
        });
    }
}

