/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.jool;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jooq.lambda.function.Function2;
import wtf.metio.memoization.core.AbstractMemoizer;

final class Function2Memoizer<KEY, FIRST, SECOND, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function2<FIRST, SECOND, OUTPUT> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final Function2<FIRST, SECOND, OUTPUT> function;

    Function2Memoizer(ConcurrentMap<KEY, OUTPUT> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, Function2<FIRST, SECOND, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function2 - provide an actual Function2 to fix this.");
    }

    public OUTPUT apply(FIRST first, SECOND second) {
        return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> this.function.apply(first, second));
    }
}

