/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Supplier;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class ActionMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements Action {
    private final Supplier<KEY> keySupplier;
    private final Action action;

    ActionMemoizer(ConcurrentMap<KEY, KEY> cache, Supplier<KEY> keySupplier, Action action) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier.");
        this.action = Objects.requireNonNull(action, "Cannot memoize a NULL Action - provide an actual Action to fix this.");
    }

    public void run() throws Throwable {
        try {
            this.computeIfAbsent(this.keySupplier.get(), key -> {
                try {
                    this.action.run();
                    return key;
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

