/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.BiFunction;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class BiConsumerMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, KEY>
implements BiConsumer<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiConsumer<FIRST, SECOND> biConsumer;

    BiConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiConsumer<FIRST, SECOND> biConsumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biConsumer = Objects.requireNonNull(biConsumer, "Cannot memoize a NULL BiConsumer - provide an actual BiConsumer to fix this.");
    }

    public void accept(FIRST first, SECOND second) throws Throwable {
        try {
            this.computeIfAbsent(this.keyFunction.apply(first, second), key -> {
                try {
                    this.biConsumer.accept(first, second);
                    return key;
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

