/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.BiFunction;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class BiFunctionMemoizer<FIRST, SECOND, KEY, VALUE>
extends AbstractMemoizer<KEY, VALUE>
implements BiFunction<FIRST, SECOND, VALUE> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiFunction<FIRST, SECOND, VALUE> biFunction;

    BiFunctionMemoizer(ConcurrentMap<KEY, VALUE> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiFunction<FIRST, SECOND, VALUE> biFunction) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biFunction = Objects.requireNonNull(biFunction, "Cannot memoize a NULL BiFunction - provide an actual BiFunction to fix this.");
    }

    public VALUE apply(FIRST first, SECOND second) throws Throwable {
        try {
            return (VALUE)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> {
                try {
                    return this.biFunction.apply(first, second);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

