/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.BiPredicate;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class BiPredicateMemoizer<FIRST, SECOND, KEY>
extends AbstractMemoizer<KEY, Boolean>
implements BiPredicate<FIRST, SECOND> {
    private final BiFunction<FIRST, SECOND, KEY> keyFunction;
    private final BiPredicate<FIRST, SECOND> biPredicate;

    BiPredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, BiFunction<FIRST, SECOND, KEY> keyFunction, BiPredicate<FIRST, SECOND> biPredicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'MemoizationDefaults::hashCodes'.");
        this.biPredicate = Objects.requireNonNull(biPredicate, "Cannot memoize a NULL BiPredicate - provide an actual BiPredicate to fix this.");
    }

    public boolean test(FIRST first, SECOND second) throws Throwable {
        try {
            return (Boolean)this.computeIfAbsent(this.keyFunction.apply(first, second), key -> {
                try {
                    return this.biPredicate.test(first, second);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

