/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Supplier;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class BooleanSupplierMemoizer<KEY>
extends AbstractMemoizer<KEY, Boolean>
implements BooleanSupplier {
    private final Supplier<KEY> keySupplier;
    private final BooleanSupplier supplier;

    BooleanSupplierMemoizer(ConcurrentMap<KEY, Boolean> cache, Supplier<KEY> keySupplier, BooleanSupplier supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL BooleanSupplier - provide an actual BooleanSupplier to fix this.");
    }

    public boolean getAsBoolean() throws Throwable {
        try {
            return (Boolean)this.computeIfAbsent(this.keySupplier.get(), key -> {
                try {
                    return this.supplier.getAsBoolean();
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

