/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.functions.Supplier;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class CancellableMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements Cancellable {
    private final Supplier<KEY> keySupplier;
    private final Cancellable cancellable;

    CancellableMemoizer(ConcurrentMap<KEY, KEY> cache, Supplier<KEY> keySupplier, Cancellable cancellable) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier.");
        this.cancellable = Objects.requireNonNull(cancellable, "Cannot memoize a NULL Cancellable - provide an actual Cancellable to fix this.");
    }

    public void cancel() throws Throwable {
        try {
            this.computeIfAbsent(this.keySupplier.get(), key -> {
                try {
                    this.cancellable.cancel();
                    return key;
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

